qui {

noi {
	/*****************************************************/
	/***** Step 2.8.2. Purging transition effects		**/
	/*****************************************************/
}

	* STEP 1: Get estimates for former newly independent & established Soviet states
	
		* Identify newly independent former Soviet states
		cd ..
		cd ".\4. Master data"
		use master_data, clear
		
		levelsof cntrycode if mother_country_name == "Russia" & cntry != "German Democratic Republic" & cntry != "North Korea" | mother_country_name == "Yugoslavia" | mother_country_name == "Czechoslovakia", local(transition_NICs)
		levelsof cntry if mother_country_name == "Russia" & cntry != "German Democratic Republic" & cntry != "North Korea" | mother_country_name == "Yugoslavia" | mother_country_name == "Czechoslovakia", local(transition_NICs2)
		
		* Identify established former Soviet states
		levelsof cntry if cntry == "Albania" | cntry == "Bulgaria" | cntry == "Hungary" | cntry == "Poland" | cntry == "Romania", local(transition_ECs)
		
		* Gather relevant data
		cd ..
		cd ".\3. Intermediary results\3.4. Intermediaries"
		use total_file, clear
		cd ..
		cd ..
	
		* Identify NICs & ECs (Established Countries)
		gen former_transition_NIC = 0
		foreach cntry in `transition_NICs' {
			replace former_transition_NIC = 1 if cntrycode == `cntry'
			}
		gen former_transition_EC = 0
		foreach cntry in `transition_ECs' {
			replace former_transition_EC = 1 if strpos(cntry, "Ukraine:") > 0 & strpos(cntry, "[`cntry']") > 0 & former_transition_EC == 0
			}
			
		* Report compostion of control group
		noi di "Sample of newly formed transition countries:", _continue
		foreach cntry in `transition_NICs2' {
			noi di "`cntry',", _continue
			}
		noi di ""
		noi di ""
		noi di "Sample of established transition countries:", _continue
		foreach cntry in `transition_ECs' {
			noi di "`cntry',", _continue
			}
			
	* STEP 2. Motivating example: Ukraine
		
		* Identify example
		sum cntrycode if cntry == "Ukraine"
		local example = `r(mean)'
							
		* Generate variables that will collect the aggregate independence dividend estimate - as well as its uncertainty - for this specific case
		preserve
		gen mean_transition = .
		gen upper_transition = .
		gen lower_transition = .
		
		* Identify established transition countries
		sum bc_lgap if cntrycode == `example' & independence_years == 20
		local label_`example' = r(mean)
		sum bc_lgap if cntry == "Ukraine: placebo country 2 [Albania]" & independence_years == 20 		// .3
		local label_albania = r(mean)+.03
		sum bc_lgap if cntry == "Ukraine: placebo country 21 [Bulgaria]" & independence_years == 20 	// .06
		local label_bulgaria = r(mean)
		sum bc_lgap if cntry == "Ukraine: placebo country 58 [Hungary]" & independence_years == 20		// -.3
		local label_hungary = r(mean)
		sum bc_lgap if cntry == "Ukraine: placebo country 102 [Poland]" & independence_years == 20		// .28
		local label_poland = r(mean)-.015
		sum bc_lgap if cntry == "Ukraine: placebo country 105 [Romania]" & independence_years == 20		// -.37
		local label_romania = r(mean)
		local year = 20.5
						
		foreach postindependencewindow of numlist -30/30 {
				ci mean bc_lgap if former_transition_EC == 1 & independence_years == `postindependencewindow' [w=popshare]
				replace mean_transition = r(mean) if independence_years == `postindependencewindow' & cntrycode == `example'
				replace lower_transition = r(lb) if independence_years == `postindependencewindow' & cntrycode == `example'
				replace upper_transition = r(ub) if independence_years == `postindependencewindow' & cntrycode == `example'
				}
		
		levelsof cntrycode if former_transition_EC == 1, local(other)
		foreach i in `other' {
				local discrepancy_transition  "`discrepancy_transition' line bc_lgap independence_years if cntrycode == `i', lc(gs13)  ||"
			}
		sort independence_years cntrycode
		
		* Plot results
		twoway `discrepancy_transition' || ///
				(line bc_lgap independence_years if cntrycode == `example', lcolor(gs0) lw(thick)) || ///
				(line lower_transition independence_years if cntrycode == `example', lcolor(edkblue) lpattern(longdash))	|| ///
				(line upper_transition independence_years if cntrycode == `example', lcolor(edkblue) lpattern(longdash))	|| ///
				(connected mean_transition independence_years if cntrycode == `example', lcolor(edkblue) mcolor(edkblue)) 	///
				if independence_years >= -10 & independence_years <= 20 , xtitle("Years of independence", size(large)) ytitle("Independence dividend", size(large)) xline(0, lpattern(tight_dot) lcolor(red)) yline(0, lpattern(tight_dot) lcolor(gs5)) graphregion(color(white)) bgcolor(white) legend(off) xlab(-10(5)25) text(`label_albania' `year' "Albania", place(e) color(gs8)) text(`label_bulgaria' `year' "Bulgaria", place(e) color(gs8)) text(`label_hungary' `year' "Hungary", place(e) color(gs8)) text(`label_poland' `year' "Poland", place(e) color(gs8)) text(`label_romania' `year' "Romania", place(e) color(gs8)) text(`label_`example'' `year' "{bf:Ukraine}", place(e) color(gs0))
		cd "./5. TeX results"
		graph export figure12_1.pdf, replace
		cd ..
		restore
		
		* Correct trajectories
		
			* Save average discrepancies in former established transistion countries
			preserve
			collapse (mean) bc_lgap  [w=popshare] if former_transition_EC == 1, by(independence_years)
			tempfile tr
			keep if independence_years > -11 & independence_years < 31
			save `tr', emptyok
			restore
			
			* Gather original trajectory
			preserve
			cd ".\3. Intermediary results\3.4. Intermediaries"
			use IDD1_`example', clear
			cd ..
			cd ..
			
			* Add estimates of transition effect
			merge 1:1 independence_years using `tr'
			drop _merge
			
			* Generate trend-demeaned synthetic trajectory
			gen lgap = baseline_lgdpcap - synth_lgdpcap_`example'
			sum lgap if independence_years >= -10 & independence_years <= -1
			gen synth_corrected = synth_lgdpcap + `r(mean)'
			
			* Generate trend-demeaned & transition-demeaned synthetic trajectory
			gen synth_doublecorrected = synth_corrected + bc_lgap	
		
			* Plot results
			local preindependence = 1981
			local maxyear = 2010
			local indepyear = 1991
			
			sort cntry year
			twoway line baseline_lgdpcap year if year >= `preindependence' & year <= `maxyear' & cntrycode == `example', lcolor(gs0) || ///
				   line synth_lgdpcap year if year >= `preindependence' & year <= `indepyear' & cntrycode == `example', lcolor(gs0) lpattern(dash) || ///
				   line synth_lgdpcap year if year >= `indepyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs8) lpattern(tight_dot) || ///
				   line synth_corrected year if year >= `indepyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs8) lpattern(tight_dot) || ///
				   line synth_doublecorrected year if year >= `indepyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0) lpattern(dash) ytitle("log per capita GDP", size(large)) xtitle(Year, size(large)) legend(order(1 "Actual with secession" 2 "Synthetic without secession"))  xline(`indepyear', lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white)
			cd "./5. TeX results"
			graph export figure12_2.pdf, replace
			cd ..
			restore
			
		* Plot corrected estimates for Ukraine
			
			* Compute corrected independence dividend & CI's
			preserve
			gen PTDIDD = .
			gen PTDIDD_ll = .
			gen PTDIDD_ul = .
			foreach year of numlist -10/30 {
				sum bc_lgap if independence_years == `year' & former_transition_EC == 1
				cap replace PTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & cntrycode == `example'
				cap replace PTDIDD_ll = PTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' & cntrycode == `example'
				cap replace PTDIDD_ul = PTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' & cntrycode == `example'
				}
			
			* Plot results
			sort cntry independence_years

			twoway	rarea PTDIDD_ul PTDIDD_ll independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', astyle(ci2) acolor(gs14) || ///
					line bc_lgap independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', lcolor(gs0)	|| ///			
					line PTDIDD independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', lpattern(longdash) lcolor(gs0) yline(0, lcolor(cranberry) lpattern(dot) lstyle(foreground)) legend(order(2 "Uncorrected" 3 "Corrected") rows(1)) lpattern(longdash) lcolor(gs0) ytitle("Gap in log per capita GDP", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot)) yline(0, lcolor(gs5) lpattern(dot))  graphregion(color(white)) bgcolor(white)
			cd "./5. TeX results"			
			graph export figure12_3.pdf, replace
			cd ..
			restore

	* STEP 3. Aggregate results
	
			* Compute corrected independence dividend & CI's
			preserve
			gen pe = .
			gen PTDIDD = .
			gen PTDIDD_ll = .
			gen PTDIDD_ul = .
			foreach year of numlist -10/30 {
				sum bc_lgap  if independence_years == `year' & former_transition_NIC == 1
				cap local pe = `r(mean)'
				cap replace pe = `r(mean)' if independence_years == `year' & cntrycode == `example'
				sum bc_lgap if independence_years == `year' & former_transition_EC == 1
				cap replace PTDIDD = `pe'-`r(mean)' if independence_years == `year' & cntrycode == `example'
				cap replace PTDIDD_ll = PTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' & cntrycode == `example'
				cap replace PTDIDD_ul = PTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' & cntrycode == `example'
				}
			
			* Plot results
			sort cntry independence_years

			twoway	rarea PTDIDD_ul PTDIDD_ll independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', astyle(ci2) acolor(gs14) || ///
					line pe independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', lcolor(gs0)	|| ///			
					line PTDIDD independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', lpattern(longdash) lcolor(gs0) yline(0, lcolor(cranberry) lpattern(dot) lstyle(foreground)) legend(order(2 "Uncorrected" 3 "Corrected") rows(1)) lpattern(longdash) lcolor(gs0) ytitle("Gap in log per capita GDP", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot)) yline(0, lcolor(gs5) lpattern(dot))  graphregion(color(white)) bgcolor(white)
			cd "./5. TeX results"			
			graph export figure12_4.pdf, replace
			cd ..
			restore
				
			* Reroute to directory containing dofiles
			cd ".\1. Dofiles"
			}
